package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Naxas_FR_door extends FrontDoor
{
	public Naxas_FR_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Naxas front right door";

		value = 1440;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.naxas:0x000000D9r, "FR window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.naxas:0x000000D9r, "FR window", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_04.naxas:0x000000E5r, "R mirror", actcolor, optical, power );
		} else
		{
			float part_random = random();
			if ( part_random >= 0.66667 ) addPart( cars.cat_04.naxas:0x000000E7r, "R mirror 3", actcolor, optical, power ); else
			if ( part_random >= 0.33333 ) addPart( cars.cat_04.naxas:0x000000E6r, "R mirror 2", actcolor, optical, power ); else
			addPart( cars.cat_04.naxas:0x000000E5r, "R mirror", actcolor, optical, power );
		}
	}
}
